/*
 * Decompiled with CFR 0.152.
 */
package org.junitee.anttask;

import java.io.IOException;
import java.io.OutputStream;
import org.junitee.anttask.AbstractResultFormatter;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PlainResultFormatter
extends AbstractResultFormatter {
    public void format(Node testSuiteNode) throws IOException {
        OutputStream out;
        NamedNodeMap attributes = testSuiteNode.getAttributes();
        String testName = this.getTestName(testSuiteNode);
        String runs = attributes.getNamedItem("tests").getNodeValue();
        int errors = Integer.parseInt(attributes.getNamedItem("errors").getNodeValue());
        int failures = Integer.parseInt(attributes.getNamedItem("failures").getNodeValue());
        String time = attributes.getNamedItem("time").getNodeValue();
        StringBuffer buffer = new StringBuffer("Testsuite: ");
        buffer.append(testName).append("\n");
        buffer.append("Tests run: ").append(runs).append("\n");
        buffer.append("Errors: ").append(errors).append("\n");
        buffer.append("Failures: ").append(failures).append("\n");
        buffer.append("Time elapsed: ").append(time).append(" sec\n\n");
        StringBuffer errorBuffer = new StringBuffer();
        StringBuffer failureBuffer = new StringBuffer();
        NodeList tests = testSuiteNode.getChildNodes();
        for (int i = 0; i < tests.getLength(); ++i) {
            Node node = tests.item(i);
            if (node.getNodeName() == null || !node.getNodeName().equals("testcase")) continue;
            NamedNodeMap testAttributes = node.getAttributes();
            String testMethod = testAttributes.getNamedItem("name").getNodeValue();
            NodeList errorFailureNodes = node.getChildNodes();
            for (int j = 0; j < errorFailureNodes.getLength(); ++j) {
                Node errorFailure = errorFailureNodes.item(j);
                StringBuffer current = null;
                if (errorFailure.getNodeName() == null) continue;
                if (errorFailure.getNodeName().equals("error")) {
                    current = errorBuffer;
                } else if (errorFailure.getNodeName().equals("failure")) {
                    current = failureBuffer;
                }
                if (current == null) continue;
                current.append("Test case: ").append(testMethod).append("\n\n");
                errorFailure.normalize();
                current.append(errorFailure.getFirstChild().getNodeValue().trim()).append("\n---");
            }
        }
        if (errors > 0) {
            buffer.append("-------------- Errors ----------------\n");
            buffer.append(errorBuffer.toString());
            buffer.append("----------- ------ ----------------\n");
            if (failures > 0) {
                buffer.append("\n");
            }
        }
        if (failures > 0) {
            buffer.append("------------- Failures ---------------\n");
            buffer.append(failureBuffer.toString());
            buffer.append("---------- -------- ---------------\n");
        }
        if ((out = this.getOutput(testName)) == null) {
            return;
        }
        out.write(buffer.toString().getBytes());
        out.flush();
    }
}

